/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.plan.Activity;
import javax.annotation.Nonnull;

public class ActivityChange {
    @Nonnull
    private final Activity activity;
    @Nonnull
    private final ChangeType changeType;

    public ActivityChange(Activity activity, ChangeType changeType) {
        this.activity = Preconditions.checkNotNull(activity, "Activity in ActivityChange must not be null.");
        this.changeType = Preconditions.checkNotNull(changeType, "ChangeType in ActivityChange must not be null.");
    }

    @Nonnull
    public Activity getActivity() {
        return this.activity;
    }

    @Nonnull
    public ChangeType getChangeType() {
        return this.changeType;
    }

    public String toString() {
        switch (this.changeType) {
            case ADDED: {
                return "+ " + this.activity.toString();
            }
            case REMOVED: {
                return "- " + this.activity.toString();
            }
        }
        return "? " + this.activity.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ActivityChange)) {
            return false;
        }
        ActivityChange that = (ActivityChange)o;
        return this.activity.equals(that.activity) && this.changeType == that.changeType;
    }

    public int hashCode() {
        int result = this.activity.hashCode();
        result = 31 * result + this.changeType.hashCode();
        return result;
    }

    public static enum ChangeType {
        ADDED,
        REMOVED;

    }
}

